/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.teastory.plugin.jei;

import cloud.lemonslice.teastory.client.gui.BambooTrayGui;
import cloud.lemonslice.teastory.client.gui.DrinkMakerGui;
import cloud.lemonslice.teastory.client.gui.StoneMillGui;
import cloud.lemonslice.teastory.client.gui.StoneRollerGui;
import cloud.lemonslice.teastory.recipe.bamboo_tray.BambooTrayBakeRecipe;
import cloud.lemonslice.teastory.recipe.bamboo_tray.BambooTrayInRainRecipe;
import cloud.lemonslice.teastory.recipe.bamboo_tray.BambooTrayIndoorsRecipe;
import cloud.lemonslice.teastory.recipe.bamboo_tray.BambooTrayOutdoorsRecipe;
import cloud.lemonslice.teastory.recipe.drink.DrinkRecipe;
import cloud.lemonslice.teastory.recipe.stone_mill.StoneMillRecipe;
import cloud.lemonslice.teastory.recipe.stone_mill.StoneRollerRecipe;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import xueluoanping.teastory.TeaStory;
import xueluoanping.teastory.plugin.jei.BambooTraySingleInCategory;
import xueluoanping.teastory.plugin.jei.DrinkMakerCategory;
import xueluoanping.teastory.plugin.jei.StoneMillCategory;
import xueluoanping.teastory.plugin.jei.StoneRollerCategory;
import xueluoanping.teastory.registry.BlockEntityRegister;
import xueluoanping.teastory.registry.BlockRegister;
import xueluoanping.teastory.registry.ItemRegister;
import xueluoanping.teastory.registry.RecipeRegister;

@JeiPlugin
public final class JEICompat
implements IModPlugin {
    private static final ResourceLocation IN_RAIN = TeaStory.rl("bamboo_tray.mode.in_rain");
    private static final ResourceLocation OUTDOORS = TeaStory.rl("bamboo_tray.mode.outdoors");
    private static final ResourceLocation INDOORS = TeaStory.rl("bamboo_tray.mode.indoors");
    private static final ResourceLocation BAKE = TeaStory.rl("bamboo_tray.mode.bake");
    public static final ResourceLocation DRINK_MAKER = TeaStory.rl("drink_maker");
    public static final ResourceLocation STONE_MILL = TeaStory.rl("stone_mill");
    public static final ResourceLocation STONE_ROLLER = TeaStory.rl("stone_roller");
    public static final RecipeType<BambooTrayInRainRecipe> IN_RAIN_TYPE = JEICompat.getType(IN_RAIN, BambooTrayInRainRecipe.class);
    public static final RecipeType<BambooTrayOutdoorsRecipe> OUTDOORS_TYPE = JEICompat.getType(OUTDOORS, BambooTrayOutdoorsRecipe.class);
    public static final RecipeType<BambooTrayIndoorsRecipe> INDOORS_TYPE = JEICompat.getType(INDOORS, BambooTrayIndoorsRecipe.class);
    public static final RecipeType<BambooTrayBakeRecipe> BAKE_TYPE = JEICompat.getType(BAKE, BambooTrayBakeRecipe.class);
    public static final RecipeType<DrinkRecipe> DRINK_MAKER_TYPE = JEICompat.getType(DRINK_MAKER, DrinkRecipe.class);
    public static final RecipeType<StoneMillRecipe> STONE_MILL_TYPE = JEICompat.getType(STONE_MILL, StoneMillRecipe.class);
    public static final RecipeType<StoneRollerRecipe> STONE_ROLLER_TYPE = JEICompat.getType(STONE_ROLLER, StoneRollerRecipe.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return TeaStory.rl("recipe");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new BambooTraySingleInCategory<BambooTrayInRainRecipe>(registry.getJeiHelpers().getGuiHelper(), IN_RAIN_TYPE, 0), new BambooTraySingleInCategory<BambooTrayOutdoorsRecipe>(registry.getJeiHelpers().getGuiHelper(), OUTDOORS_TYPE, 1), new BambooTraySingleInCategory<BambooTrayIndoorsRecipe>(registry.getJeiHelpers().getGuiHelper(), INDOORS_TYPE, 2), new BambooTraySingleInCategory<BambooTrayBakeRecipe>(registry.getJeiHelpers().getGuiHelper(), BAKE_TYPE, 3)});
        registry.addRecipeCategories(new IRecipeCategory[]{new DrinkMakerCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new StoneMillCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new StoneRollerCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{(Item)BlockRegister.CHRYSANTHEMUM_ITEM.get(), (Item)BlockRegister.HYACINTH_ITEM.get(), (Item)BlockRegister.ZINNIA_ITEM.get(), (Item)ItemRegister.BOTTLE_DRINK.get(), (Item)ItemRegister.PORCELAIN_CUP_DRINK.get(), (Item)BlockEntityRegister.PORCELAIN_TEAPOT.get()});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockEntityRegister.BAMBOO_TRAY_ITEM.get()), new RecipeType[]{IN_RAIN_TYPE, OUTDOORS_TYPE, INDOORS_TYPE, BAKE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockEntityRegister.DRINK_MAKER_ITEM.get()), new RecipeType[]{DRINK_MAKER_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockEntityRegister.STONE_MILL_ITEM.get()), new RecipeType[]{STONE_MILL_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockEntityRegister.STONE_ROLLER_ITEM.get()), new RecipeType[]{STONE_ROLLER_TYPE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(BambooTrayGui.class, 77, 32, 22, 17, new RecipeType[]{IN_RAIN_TYPE, OUTDOORS_TYPE, INDOORS_TYPE, BAKE_TYPE});
        registration.addRecipeClickArea(DrinkMakerGui.class, 98, 37, 24, 17, new RecipeType[]{DRINK_MAKER_TYPE});
        registration.addRecipeClickArea(StoneMillGui.class, 77, 37, 22, 17, new RecipeType[]{STONE_MILL_TYPE});
        registration.addRecipeClickArea(StoneRollerGui.class, 77, 37, 22, 17, new RecipeType[]{STONE_ROLLER_TYPE});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(IN_RAIN_TYPE, JEICompat.getRecipes((net.minecraft.world.item.crafting.RecipeType)RecipeRegister.BAMBOO_TRAY_IN_RAIN.get()));
        registration.addRecipes(OUTDOORS_TYPE, JEICompat.getRecipes((net.minecraft.world.item.crafting.RecipeType)RecipeRegister.BAMBOO_TRAY_OUTDOORS.get()));
        registration.addRecipes(INDOORS_TYPE, JEICompat.getRecipes((net.minecraft.world.item.crafting.RecipeType)RecipeRegister.BAMBOO_TRAY_INDOORS.get()));
        registration.addRecipes(BAKE_TYPE, JEICompat.getRecipes((net.minecraft.world.item.crafting.RecipeType)RecipeRegister.BAMBOO_TRAY_BAKE.get()));
        registration.addRecipes(DRINK_MAKER_TYPE, JEICompat.getRecipes((net.minecraft.world.item.crafting.RecipeType)RecipeRegister.DRINK_MAKER.get()));
        registration.addRecipes(STONE_MILL_TYPE, JEICompat.getRecipes((net.minecraft.world.item.crafting.RecipeType)RecipeRegister.STONE_MILL.get()));
        registration.addRecipes(STONE_ROLLER_TYPE, JEICompat.getRecipes((net.minecraft.world.item.crafting.RecipeType)RecipeRegister.STONE_ROLLER.get()));
    }

    public static <T> RecipeType<T> getType(ResourceLocation rs, Class<? extends T> recipeClass) {
        return RecipeType.create((String)rs.m_135827_(), (String)rs.m_135815_(), recipeClass);
    }

    private static <T extends Recipe<?>> List<T> getRecipes(@NotNull net.minecraft.world.item.crafting.RecipeType<T> type) {
        return Minecraft.m_91087_().f_91073_.m_7465_().m_44051_().stream().filter(r -> r.m_6671_() == type).map(c -> c).collect(Collectors.toList());
    }
}

